#' Thirty datasets with inapplicable data
#' 
#' These are the datasets used to evaluate the behaviour of the inapplicable
#' algorithm in \insertCite{Brazeau2018}{TreeTools}.
#'
#' The name of each item corresponds to the datasets listed below.
#' Datasets are sorted into two subsets, each sorted alphabetically;
#' the first subset comprise simpler datasets with faster processing times.
#' The value is the dataset in the format generated by [`read.nexus.data()`].
#'
#' @template inapplicableSources
#'
#' @references
#' \insertAllCited{}
#' 
#' @keywords datasets
"inapplicable.datasets"

#' Thirty datasets with inapplicable data
#' 
#' These are the datasets used to evaluate the behaviour of the inapplicable
#' algorithm in \insertCite{Brazeau2018}{TreeTools}.
#'
#' The name of each item corresponds to the datasets listed below.
#' Datasets are sorted into two subsets, each sorted alphabetically;
#' the first subset comprise simpler datasets with faster processing times.
#' The value is the dataset in \code{phyDat} format.
#'
#' @template inapplicableSources
#'
#' @references
#' \insertAllCited{}
#'
#' @keywords datasets
"inapplicable.phyData"

#' Thirty datasets with inapplicable data
#' 
#' These are the datasets used to evaluate the behaviour of the inapplicable algorithm 
#' in \insertCite{Brazeau2018}{TreeTools}.
#'
#' The name of each item corresponds to the datasets listed below.  The value gives its citation.
#'
#' @template inapplicableSources
#'
#' @references
#' \insertAllCited{}
#'
#' @keywords datasets
"inapplicable.citations"

#' 100 simulated data matrices 
#'
#' Contains the 100 simulated matrices generated by
#' \insertCite{Congreve2016}{TreeSearch} using a heterogeneous Markov-k model,
#' generated from the \link{referenceTree} topology, with 
#' all branches sharing an equal length.
#'
#' @format A list with 100 entries, each comprising a `phyDat` object of 55
#' characters for 22 taxa
#'
#' @references 
#'  \insertAllCited{}
#' 
#' @examples 
#' data('referenceTree')
#' data('congreveLamsdellMatrices')
#' TreeLength(referenceTree, congreveLamsdellMatrices[[17]], 'profile')
#'
#' @source \doi{10.5061/dryad.7dq0j}
#' 
#' @keywords datasets
"congreveLamsdellMatrices"

#' Tree topology for matrix simulation
#'
#' The tree topology used to generate the matrices in 
#' \code{\link{congreveLamsdellMatrices}} 
#'
#' @format A single phylogenetic tree saved as an object of class \code{phylo}
#'
#' @references 
#'  \insertRef{Congreve2016}{TreeSearch}
#'  \insertRef{Congreve2016dd}{TreeSearch}
#' 
#' @examples 
#' data(referenceTree)
#' plot(referenceTree)
#' 
#' @source Congreve & Lamsdell (2016); \doi{10.1111/pala.12236}
#' 
#' @keywords datasets
"referenceTree"

#' Empirically counted profiles for small trees
#' 
#' The base 2 logarithm of the number of trees containing _s_ steps, calculated
#' by scoring a character on each _n_-leaf tree.
#' 
#' @format A list with the structure 
#' `profiles[[number of leaves]][[number of tokens]][[tokens in smallest split]]`
#' The list entry returns a named numeric vector; each entry lists 
#' log2(proportion of _n_-leaf trees with _s_ or fewer steps for this character).
#' 
#' @examples 
#' data(profiles)
#' 
#' # Load profile for a character of the structure 0 0 0 1 1 1 1 1
#' profile3.5 <- profiles[[8]][[2]][[3]]
#' 
#' # Number of trees with _s_ or fewer steps on that character
#' TreeTools::NUnrooted(8) * 2 ^ profile3.5
#' @family profile parsimony functions
"profiles"