% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/plot_extras.R
\name{tlsPlot}
\alias{tlsPlot}
\alias{add_segmentIDs}
\alias{add_treeIDs}
\alias{add_treeMap}
\alias{add_treePoints}
\alias{add_stemPoints}
\alias{add_stemSegments}
\alias{add_tlsInventory}
\title{Plot \emph{TreeLS} outputs}
\usage{
tlsPlot(..., fast = FALSE, tree_id = NULL, segment = NULL)

add_segmentIDs(x, las, ...)

add_treeIDs(x, las, ...)

add_treeMap(x, las, ...)

add_treePoints(x, las, color_func = pastel.colors, ...)

add_stemPoints(x, las, ...)

add_stemSegments(x, stems_data_table, color = "white", fast = FALSE)

add_tlsInventory(x, inventory_data_table, color = "white", fast = FALSE)
}
\arguments{
\item{...}{in \code{tlsPlot}: any object returned from a \emph{TreeLS} method. In the \code{add_*} methods: parameters passed down to 3D plotting \code{rgl} functions.}

\item{fast}{\code{logical}, use \code{TRUE} to plot spheres representing tree diameters or \code{FALSE} to plot detailed 3D cylinders.}

\item{tree_id}{\code{numeric} - plot only the tree matching this tree id.}

\item{segment}{\code{numeric} - plot only stem segments matching this segment id.}

\item{x}{output from \code{\link[lidR:plot]{plot}} or \code{tlsPlot}}

\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{color_func}{color palette function used in \code{add_treePoints}.}

\item{stems_data_table, inventory_data_table}{\code{data.table} objects generated by \code{stemSegmentation} and \code{tlsInventory}.}

\item{color}{color of 3D objects.}
}
\description{
Plot the outputs of \emph{TreeLS} methods on the same scene using \code{rgl}.
}
\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file) \%>\%
  tlsNormalize \%>\%
  stemPoints(stm.hough())

dmt = shapeFit(shape = 'circle', algorithm='ransac', n=20)
inv = tlsInventory(tls, d_method = dmt)

### quick plot
tlsPlot(tls, inv)

### customizable plots
x = plot(tls)
add_stemPoints(x, tls, color='red', size=3)
add_tlsInventory(x, inv, color='yellow')
add_segmentIDs(x, tls, color='white', cex=2, pos=4)
}
