% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Res_stom_O3.R
\name{Res_stom_O3}
\alias{Res_stom_O3}
\title{Res_stom_O3 - Calculates stomata resistance on an hourly basis}
\usage{
Res_stom_O3(x, m2 = 1, m3 = 4)
}
\arguments{
\item{x}{A data frame containing hourly data of weather and other variables (e.g. Hum (\%), Pres (kPa), Precip (mm), Rad (W m-2), Temp (C), Wind (m s-1), Daylight (Night or Daylight), BAI, LAI)}

\item{m2}{Dimensionless slope for different air pollutants}

\item{m3}{Dimensionless slope for different species}
}
\value{
Hourly data of stomata resistance (s m-1)
}
\description{
Res_stom_O3 - Calculates stomata resistance on an hourly basis
}
\examples{

data(Bizkaia_data)
Res_stom_O3(x = Bizkaia_data)
}
