% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformedParPosthoc.R
\name{transformedParameters}
\alias{transformedParameters}
\title{Get Transformed Parameters}
\usage{
transformedParameters(fittedModel, transformedParameters, level = "group",
  nCPU = 4)
}
\arguments{
\item{fittedModel}{fitted latent-trait or beta MPT model (\code{\link{traitMPT}}, \code{\link{betaMPT}})}

\item{transformedParameters}{list with parameter transformations that should be computed based on the posterior samples (e.g., for testing parameter differences: \code{list("diffD=Do-Dn")})}

\item{level}{whether to compute transformations of \code{"group"} or \code{"individual"} estimates}

\item{nCPU}{number of CPU cores across which the MCMC chains are distributed}
}
\value{
an \link[coda]{mcmc.list} of posterior samples for the transformed parameters
}
\description{
Computes transformations of MPT parameters based on the MCMC posterior samples (e.g., differences of parameters)
}
\examples{
\dontrun{
tt <- transformedParameters(fittedModel,
                            list("diff=a-b","p=a>b"),
                            level="individual")
summary(tt)
}
}

