% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readEQN.R
\name{readEQN}
\alias{readEQN}
\title{Read multiTree files}
\usage{
readEQN(file, restrictions = NULL, paramOrder = FALSE)
}
\arguments{
\item{file}{The (full path to the) file that specifies the multitree MPT file}

\item{restrictions}{Optional: The (full path to the) file that specifies which parameters should be constants and which should be equal. Alternatively: a list of restrictions, e.g., \code{list("D1=D2","g=0.5")}}

\item{paramOrder}{if TRUE, the order of MPT parameters as interally used is printed.}
}
\description{
Function to import MPT models from standard .eqn model files as used, for instance, by multiTree (Moshagen, 2010).
}
\details{
The file format should adhere to the standard .eqn-syntax (note that the first line is skipped and can be used for comments). In each line, a separate branch of the MPT model is specified using the tree label, category label, and the model equations in full form (multiplication sign `*` required; not abbreviations such as `a^2` allowed).

As an example, the standard two-high threshold model (2HTM) is defined as follows:

 \tabular{lllll}{
\code{Target } \tab \tab \code{Hit}             \tab \tab \code{Do} \cr
\code{Target}  \tab \tab \code{Hit}             \tab \tab \code{(1-Do)*g} \cr
\code{Target}  \tab \tab \code{Miss}            \tab \tab \code{(1-Do)*(1-g)} \cr
\code{Lure}    \tab \tab \code{FalseAlarm}      \tab \tab \code{(1-Dn)*g}  \cr
\code{Lure}    \tab \tab \code{CorrectReject}   \tab \tab \code{(1-Dn)*(1-g)} \cr
\code{Lure}    \tab \tab \code{CorrectReject  } \tab \tab \code{Dn}
}
}
\examples{
# Example: Standard Two-High-Threshold Model (2HTM)
EQNfile <- system.file("MPTmodels/2htm.eqn", package="TreeBUGS")
readEQN(file = EQNfile, paramOrder = TRUE)

# with equality constraint:
readEQN(file = EQNfile, restrictions = list("Dn=Do", "g=0.5"), paramOrder = TRUE)
}
\author{
Daniel Heck, Denis Arnold, Nina Arnold
}
\references{
Moshagen, M. (2010). multiTree: A computer program for the analysis of multinomial processing tree models. Behavior Research Methods, 42, 42-54.
}

