% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichCirclize.R
\name{selectPathways}
\alias{selectPathways}
\title{Randomly Select Pathways with Limited Word Count}
\usage{
selectPathways(pathways, max_words = 10, num_select = 10)
}
\arguments{
\item{pathways}{Character vector of pathways.}

\item{max_words}{Integer, maximum number of words allowed in the pathway name.}

\item{num_select}{Integer, number of pathways to randomly select.}
}
\value{
A character vector of selected pathways.
}
\description{
This function randomly selects a specified number of pathways from a given list, ensuring that each selected pathway name does not exceed a specified number of words. It filters out pathways with names longer than the specified word limit before making the selection.
}
\examples{
pathway_list <- c("pathway_one response to stimulus",
                  "pathway_two cell growth and death",
                  "pathway_three regulation of cellular process",
                  "pathway_four metabolic process")
selected_pathways <- selectPathways(pathway_list, max_words = 5, num_select = 2)

}
