summary.TransModel <-
function(object,...){
  if(object$p==0){
    class(object)<-"summary.TransModel"
    return(object)
  }
   if(object$p>0){
	se<-sqrt(diag(object$vcov))
	zval<-coef(object)/se
	TAB<-cbind(Estimate=coef(object),
           StdErr=se,
           z.value=zval,
           p.value=2*pnorm(-abs(zval)))
      col<-ncol(object$data)-1
	rownames(TAB)<-names(object$coefficients)
	res<-list(call=object$call,p=object$p,coefficients=TAB)
	class(res)<-"summary.TransModel"
	return(res)
   }
}
