% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRD.R
\docType{class}
\name{IRDSwap-class}
\alias{IRDSwap}
\title{IRD Swap Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency set that the trade belongs to}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}
}
\value{
An object of type IRDSwap
}
\description{
Creates an IRD Swap Object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}

\examples{

# the IRD Swap trade given in the Basel regulation IRD example
tr1 = IRDSwap(Notional=10000,MtM=30,Currency="USD",Si=0,Ei=10,BuySell='Buy')
}
