% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{set_missing_count}
\alias{set_missing_count}
\title{Set the display for missing strings}
\usage{
set_missing_count(e, fmt = NULL, sort_value = NULL, denom_ignore = FALSE, ...)
}
\arguments{
\item{e}{A \code{count_layer} object}

\item{fmt}{An f_str object to change the display of the missing counts}

\item{sort_value}{A numeric value that will be used in the ordering column.
This should be numeric. If it is not supplied the ordering column will be
the maximum value of what appears in the table plus one.}

\item{denom_ignore}{A boolean. Specifies Whether or not to include the
missing counts specified within the ... parameter within denominators. If
set to TRUE, the values specified within ... will be ignored.}

\item{...}{Parameters used to note which values to describe as missing.
Generally NA and "Missing" would be used here. Parameters can be named
character vectors where the names become the row label.}
}
\value{
The modified layer
}
\description{
Controls how missing counts are handled and displayed in the layer
}
\examples{
library(magrittr)
library(dplyr)
  mtcars2 <- mtcars \%>\%
mutate_all(as.character)
mtcars2[mtcars$cyl == 6, "cyl"] <- NA

tplyr_table(mtcars2, gear) \%>\%
  add_layer(
    group_count(cyl) \%>\%
      set_missing_count(f_str("xx ", n), Missing = NA)
  ) \%>\%
  build()
}
