% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-fishery-statistics.R
\name{calculate_fish_weight}
\alias{calculate_fish_weight}
\title{Calculate fish weight from length}
\usage{
calculate_fish_weight(length, a, b)
}
\arguments{
\item{length}{Numeric vector of fish lengths.}

\item{a}{Coefficient of the length-weight relationship.}

\item{b}{Exponent of the length-weight relationship.}
}
\value{
Numeric vector of estimated weights.
}
\description{
Estimates individual fish weight from length using the length-weight relationship: W = a * L^b
}
\details{
The length-weight relationship follows the allometric equation W = a * L^b,
where W is weight, L is length, and a and b are species-specific parameters.
}
\references{
Froese, R. (2006). Cube law, condition factor and weight–length relationships:
history, meta-analysis and recommendations. Journal of Applied Ichthyology, 22(4), 241-253.
}
