% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_two_groups.R
\name{plot_two_groups}
\alias{plot_two_groups}
\title{Plot output from boot_two_groups}
\arguments{
\item{x}{Output from boot_two_groups function. Defaults to 'sims'.}

\item{n_max}{Numeric. Maximum sample size to extrapolate simulations.}

\item{n_min}{Numeric. Minimum sample size to extrapolate simulations.
Defaults to 3.}

\item{colour_exp}{Colour of the experimental data. Defaults to "blue".}

\item{colour_extrap}{Colour of the extrapolated data. Defaults to "red".}

\item{legend.position}{Position of the legend. Defaults to "top". Can be "bottom", "left", "right", or "none".}

\item{alpha_val}{Change the degree of shading of the graphs. Default is 0.2.}

\item{ggtheme}{The theme for the ggplot created. See ggplot2 themes for options. Default set to theme_classic().}
}
\value{
Two plots: (a) the precision of the estimates for the difference in CTmin
between the two selected groups across sample sizes; (b)
the 95% confidence interval of the mean difference in CTmin between the two selected groups.
}
\description{
Plot output from boot_two.
}
\examples{
\donttest{
sims <- boot_two(data = coreid_data,
                        groups_col = col,
                        response = response,
                        group1 = "Catorhintha schaffneri_APM",
                        group2 = "Catorhintha schaffneri_NPM",
                        n_max = 30,
                        iter = 99)

plots <- plot_two_groups(x = sims,
                         n_min = 3,
                         n_max = 30,
                         colour_exp = "gold",
                         colour_extrap = "darkgreen",
                         legend.position = "right")
}
}
