% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{downloadTestData}
\alias{downloadTestData}
\title{Download Test Data Files}
\usage{
downloadTestData(
  datasetName = "mimicIV",
  cdmVersion = "5.3",
  pathToData = Sys.getenv("STUDY_DATASETS"),
  overwrite = FALSE
)
}
\arguments{
\item{datasetName}{The data set name as found on https://github.com/darwin-eu/EunomiaDatasets. The
data set name corresponds to the folder with the data set ZIP files}

\item{cdmVersion}{The OMOP CDM version. This version will appear in the suffix of the data file,
for example: synpuf_5.3.zip. Default: '5.3'}

\item{pathToData}{The path where the Eunomia data is stored on the file system., By default the
value of the environment variable "EUNOMIA_DATA_FOLDER" is used.}

\item{overwrite}{Control whether the existing archive file will be overwritten should it already exist.}
}
\value{
Invisibly returns the destination if the download was successful.
}
\description{
Download Test Data Files
}
\examples{
\dontrun{
downloadTestData()
}
}
