% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions1.R, R/functionsMultiOut1.R
\name{TF_branin}
\alias{TF_branin}
\alias{TF_borehole}
\alias{TF_franke}
\alias{TF_zhou1998}
\alias{TF_currin1991}
\alias{TF_currin1991b}
\alias{TF_limpoly}
\alias{TF_limnonpoly}
\alias{TF_banana}
\alias{TF_banana_grad}
\alias{TF_gaussian1}
\alias{TF_sinumoid}
\alias{TF_sqrtsin}
\alias{TF_powsin}
\alias{TF_OTL_Circuit}
\alias{TF_boreholeMV}
\title{Base test function.}
\usage{
TF_branin(
  x,
  a = 1,
  b = 5.1/(4 * pi^2),
  cc = 5/pi,
  r = 6,
  s = 10,
  tt = 1/(8 * pi)
)

TF_borehole(x)

TF_franke(x)

TF_zhou1998(x)

TF_currin1991(x)

TF_currin1991b(x)

TF_limpoly(x)

TF_limnonpoly(x)

TF_banana(x)

TF_banana_grad(x, v1, v2)

TF_gaussian1(x, center = 0.5, s2 = 0.01)

TF_sinumoid(x)

TF_sqrtsin(x, freq = 2 * pi)

TF_powsin(x, freq = 2 * pi, pow = 0.7)

TF_OTL_Circuit(x)

TF_boreholeMV(x, NOD = 51)
}
\arguments{
\item{x}{Input vector at which to evaluate.}

\item{a}{Parameter for TF_branin}

\item{b}{Parameter for TF_branin}

\item{cc}{Parameter for TF_branin}

\item{r}{Parameter for TF_branin}

\item{s}{Parameter for TF_branin}

\item{tt}{Parameter for TF_branin}

\item{v1}{Scale parameter for first dimension}

\item{v2}{Scale parameter for second dimension}

\item{center}{Where to center the function, a vector.}

\item{s2}{Variance of the Gaussian.}

\item{freq}{Wave frequency for TF_sqrtsin and TF_powsin}

\item{pow}{Power to raise wave to for TF_powsin.}

\item{NOD}{number of output dimensions.}
}
\value{
Function output evaluated at x.
}
\description{
TF_branin: A function taking in a single vector.
2 dimensional function.
See corresponding function with "TF_" for more details.
}
\examples{
TF_branin(runif(2))
TF_borehole(runif(8))
TF_franke(runif(2))
TF_zhou1998(runif(2))
TF_currin1991(runif(2))
TF_currin1991b(runif(2))
TF_limpoly(runif(2))
TF_limnonpoly(runif(2))
TF_banana(runif(2))
TF_banana_grad(runif(2), v1=40, v2=15)
TF_gaussian1(runif(2))
TF_sinumoid(runif(2))
TF_sqrtsin(runif(2))
TF_powsin(runif(2))
TF_OTL_Circuit(c(50,25,0.5,1.2,0.25,50))
TF_boreholeMV(runif(8))
}
\references{
Dixon, L. C. W. (1978). The global optimization problem: an introduction. Towards Global Optimiation 2, 1-15.

Morris, M. D., Mitchell, T. J., & Ylvisaker, D. (1993). Bayesian design and analysis of computer experiments: use of derivatives in surface prediction. Technometrics, 35(3), 243-255.

Worley, Brian A. Deterministic uncertainty analysis. No. ORNL-6428. Oak Ridge National Lab., TN (USA), 1987.

Franke, R. (1979). A critical comparison of some methods for interpolation of scattered data. Monterey, California: Naval Postgraduate School. Page 13.

An, J., & Owen, A. (2001). Quasi-regression. Journal of complexity, 17(4), 588-607.

Currin, C., Mitchell, T., Morris, M., & Ylvisaker, D. (1991). Bayesian prediction of deterministic functions, with applications to the design and analysis of computer experiments. Journal of the American Statistical Association, 86(416), 953-963.

Currin, C., Mitchell, T., Morris, M., & Ylvisaker, D. (1991). Bayesian prediction of deterministic functions, with applications to the design and analysis of computer experiments. Journal of the American Statistical Association, 86(416), 953-963.

Haario, H., Saksman, E., & Tamminen, J. (1999). Adaptive proposal distribution for random walk Metropolis algorithm. Computational Statistics, 14(3), 375-396.

Joseph, V. R., Dasgupta, T., Tuo, R., & Wu, C. J. (2015). Sequential exploration of complex surfaces using minimum energy designs. Technometrics, 57(1), 64-74.

Ben-Ari, Einat Neumann, and David M. Steinberg. "Modeling data
from computer experiments: an empirical comparison of kriging with MARS and
projection pursuit regression." Quality Engineering 19.4 (2007): 327-338.

Morris, M. D., Mitchell, T. J., & Ylvisaker, D. (1993). Bayesian design and analysis of computer experiments: use of derivatives in surface prediction. Technometrics, 35(3), 243-255.

Worley, Brian A. Deterministic uncertainty analysis. No. ORNL-6428. Oak Ridge National Lab., TN (USA), 1987.
}
