% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_core_documents.r, R/RcppExports.R
\name{info_item}
\alias{info_item}
\alias{info_1pl}
\alias{info_2pl}
\alias{info_3pl}
\alias{info_pc}
\alias{info_gpc}
\alias{info_gr}
\alias{array_info_1pl}
\alias{array_info_2pl}
\alias{array_info_3pl}
\alias{array_info_pc}
\alias{array_info_gpc}
\alias{array_info_gr}
\title{(C++) Calculate Fisher information}
\usage{
info_1pl(x, b)

info_2pl(x, a, b)

info_3pl(x, a, b, c)

info_pc(x, b)

info_gpc(x, a, b)

info_gr(x, a, b)

array_info_1pl(x, b)

array_info_2pl(x, a, b)

array_info_3pl(x, a, b, c)

array_info_pc(x, b)

array_info_gpc(x, a, b)

array_info_gr(x, a, b)
}
\arguments{
\item{x}{the theta value. This must be a column vector in matrix form for \code{array_info_*()} functions.}

\item{a, b, c}{the item parameters.}
}
\description{
\code{info_*()} and \code{array_info_*()} are functions for calculating Fisher information.
}
\details{
\code{info_*()} functions accept a single theta value, and \code{array_info_*} functions accept multiple theta values.

Currently supports unidimensional models.

\itemize{
  \item{\code{info_1pl()}, \code{array_info_1pl()}}: 1PL models
  \item{\code{info_2pl()}, \code{array_info_2pl()}}: 2PL models
  \item{\code{info_3pl()}, \code{array_info_3pl()}}: 3PL models
  \item{\code{info_pc()}, \code{array_info_pc()}}: PC (partial credit) models
  \item{\code{info_gpc()}, \code{array_info_gpc()}}: GPC (generalized partial credit) models
  \item{\code{info_gr()}, \code{array_info_gr()}}: GR (graded response) models
}
}
\examples{
x <- 0.5

info_1pl(x, 1)
info_2pl(x, 1, 2)
info_3pl(x, 1, 2, 0.25)
info_pc(x, c(0, 1))
info_gpc(x, 2, c(0, 1))
info_gr(x, 2, c(0, 2))

x <- matrix(seq(0.1, 0.5, 0.1)) # column vector in matrix form

array_info_1pl(x, 1)
array_info_2pl(x, 1, 2)
array_info_3pl(x, 1, 2, 0.25)
array_info_pc(x, c(0, 1))
array_info_gpc(x, 2, c(0, 1))
array_info_gr(x, 2, c(0, 2))

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
