% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_core_documents.r, R/RcppExports.R
\name{e_item}
\alias{e_item}
\alias{e_1pl}
\alias{e_2pl}
\alias{e_3pl}
\alias{e_pc}
\alias{e_gpc}
\alias{e_gr}
\alias{array_e_1pl}
\alias{array_e_2pl}
\alias{array_e_3pl}
\alias{array_e_pc}
\alias{array_e_gpc}
\alias{array_e_gr}
\title{(C++) Calculate expected scores}
\usage{
e_1pl(x, b)

e_2pl(x, a, b)

e_3pl(x, a, b, c)

e_pc(x, b)

e_gpc(x, a, b)

e_gr(x, a, b)

array_e_1pl(x, b)

array_e_2pl(x, a, b)

array_e_3pl(x, a, b, c)

array_e_pc(x, b)

array_e_gpc(x, a, b)

array_e_gr(x, a, b)
}
\arguments{
\item{x}{the theta value. This must be a column vector in matrix form for \code{array_e_*()} functions.}

\item{a, b, c}{the item parameters.}
}
\description{
\code{e_*()} and \code{array_e_*()} are C++ functions for calculating expected scores.
}
\details{
\code{e_*()} functions accept a single theta value, and \code{array_p_*()} functions accept multiple theta values.

Currently supports unidimensional models.

\itemize{
  \item{\code{e_1pl()}, \code{array_e_1pl()}}: 1PL models
  \item{\code{e_2pl()}, \code{array_e_2pl()}}: 2PL models
  \item{\code{e_3pl()}, \code{array_e_3pl()}}: 3PL models
  \item{\code{e_pc()}, \code{array_e_pc()}}: PC (partial credit) models
  \item{\code{e_gpc()}, \code{array_e_gpc()}}: GPC (generalized partial credit) models
  \item{\code{e_gr()}, \code{array_e_gr()}}: GR (graded response) models
}
}
\examples{
x <- 0.5

e_1pl(x, 1)
e_2pl(x, 1, 2)
e_3pl(x, 1, 2, 0.25)
e_pc(x, c(0, 1))
e_gpc(x, 2, c(0, 1))
e_gr(x, 2, c(0, 2))

x <- matrix(seq(-3, 3, 1)) # column vector in matrix form

array_e_1pl(x, 1)
array_e_2pl(x, 1, 2)
array_e_3pl(x, 1, 2, 0.25)
array_e_pc(x, c(0, 1))
array_e_gpc(x, 2, c(0, 1))
array_e_gr(x, 2, c(0, 2))

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
