% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\name{Shadow}
\alias{Shadow}
\alias{Shadow,config_Shadow-method}
\title{Run adaptive test assembly}
\usage{
Shadow(
  config,
  constraints = NULL,
  true_theta = NULL,
  data = NULL,
  prior = NULL,
  prior_par = NULL,
  exclude = NULL,
  include_items_for_estimation = NULL,
  force_solver = FALSE,
  session = NULL,
  seed = NULL
)

\S4method{Shadow}{config_Shadow}(
  config,
  constraints = NULL,
  true_theta = NULL,
  data = NULL,
  prior = NULL,
  prior_par = NULL,
  exclude = NULL,
  include_items_for_estimation = NULL,
  force_solver = FALSE,
  session = NULL,
  seed = NULL
)
}
\arguments{
\item{config}{a \code{\linkS4class{config_Shadow}} object. Use \code{\link{createShadowTestConfig}} for this.}

\item{constraints}{a \code{\linkS4class{constraints}} object representing test specifications. Use \code{\link{loadConstraints}} for this.}

\item{true_theta}{(optional) true theta values to use in simulation. Either \code{true_theta} or \code{data} must be supplied.}

\item{data}{(optional) a matrix containing item response data to use in simulation. Either \code{true_theta} or \code{data} must be supplied.}

\item{prior}{(optional) prior density at each \code{config@theta_grid}. This overrides \code{prior_par}. Can be a vector to use the same prior for all \emph{nj} participants, or a \emph{nj}-row matrix to use a different prior for each participant.}

\item{prior_par}{(optional) normal distribution parameters \code{c(mean, sd)} to use as prior. Can be a vector to use the same prior for all \emph{nj} participants, or a \emph{nj}-row matrix to use a different prior for each participant.}

\item{exclude}{(optional) a list containing item names in \code{$i} and set names in \code{$s} to exclude from selection for each participant. The length of the list must be equal to the number of participants.}

\item{include_items_for_estimation}{(optional) an examinee-wise list containing:
\itemize{
  \item{\code{administered_item_pool}} items to include in theta estimation as \code{\linkS4class{item_pool}} object.
  \item{\code{administered_item_resp}} item responses to include in theta estimation.
}}

\item{force_solver}{if \code{TRUE}, do not check whether the solver is one of recommended solvers for doing set-based assembly. Has no effect on discrete assembly. (default = \code{FALSE})}

\item{session}{(optional) used to communicate with Shiny app \code{\link{TestDesign}}.}

\item{seed}{(optional) used to perform data generation internally.}
}
\value{
\code{\link{Shadow}} returns an \code{\linkS4class{output_Shadow_all}} object containing assembly results.
}
\description{
\code{\link{Shadow}} is a test assembly function to perform adaptive test assembly based on the generalized shadow-test framework.
}
\examples{
config <- createShadowTestConfig()
true_theta <- rnorm(1)
solution <- Shadow(config, constraints_science, true_theta)
solution@output
}
\references{
van der Linden, W. J., Reese, L. M. (1998).
A model for optimal constrained adaptive testing.
\emph{Applied Psychological Measurement, 22}, 259-270.

van der Linden, W. J. (1998).
Optimal assembly of psychological and educational tests.
\emph{Applied Psychological Measurement, 22}, 195-211.

van der Linden, W. J. (2000).
Optimal assembly of tests with item sets.
\emph{Applied Psychological Measurement, 24}, 225-240.

van der Linden, W. J. (2005).
\emph{Linear models for optimal test design.}
Springer Science & Business Media.
}
