% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_functions.R
\docType{methods}
\name{plotInfo}
\alias{plotInfo}
\alias{plotInfo,list-method}
\alias{plotInfo,item_pool-method}
\alias{plotInfo,constraints-method}
\title{Draw item information plots}
\usage{
plotInfo(object, theta = seq(-3, 3, 0.1), info_type = "FISHER",
  plot_sum = TRUE, select = NULL, color = "blue", file_pdf = NULL,
  width = 7, height = 6, mfrow = c(2, 4))

\S4method{plotInfo}{list}(object, theta = seq(-3, 3, 0.1),
  info_type = "FISHER", plot_sum = TRUE, select = NULL,
  color = "blue", file_pdf = NULL, width = 7, height = 6,
  mfrow = c(2, 4))

\S4method{plotInfo}{item_pool}(object, theta = seq(-3, 3, 0.1),
  info_type = "FISHER", plot_sum = TRUE, select = NULL,
  color = "blue", file_pdf = NULL, width = 7, height = 6,
  mfrow = c(1, 1))

\S4method{plotInfo}{constraints}(object, theta = seq(-3, 3, 0.1),
  info_type = "FISHER", plot_sum = TRUE, select = NULL,
  color = "black", file_pdf = NULL, width = 7, height = 6,
  mfrow = c(1, 1))
}
\arguments{
\item{object}{An \code{\linkS4class{item_pool}} object to draw pool-level or item-level information, or a list from \code{\link{Static}} to draw test-level information.}

\item{theta}{Theta values for drawing the curve. Default is \code{seq(-3, 3, .1)}.}

\item{info_type}{Type of information. Currently only accepts \code{FISHER} (default).}

\item{plot_sum}{When 'object' is an \code{\linkS4class{item_pool}} object, if \code{TRUE} then draw pool-level information, and if \code{FALSE} draw item-level information for every item in the pool.}

\item{select}{A vector of indices identifying the items to subset, for when 'object' is an \code{\linkS4class{item_pool}} object.}

\item{color}{The color of the curve.}

\item{file_pdf}{If supplied a filename, save as a PDF file.}

\item{width}{Width of graphics device.}

\item{height}{Width of graphics device.}

\item{mfrow}{Multipanel configurations as c(nrow, ncol).}
}
\description{
Draw item information plots.
}
\examples{
subitempool <- subsetItemPool(itempool_science, 1:8)
plotInfo(subitempool)

config <- createStaticTestConfig()
solution <- Static(config, constraints_science)
plotInfo(solution)

}
