% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_functions.R
\docType{methods}
\name{calcLocation}
\alias{calcLocation}
\alias{calcLocation,item_1PL-method}
\alias{calcLocation,item_1PL,numeric-method}
\alias{calcLocation,item_2PL-method}
\alias{calcLocation,item_2PL,numeric-method}
\alias{calcLocation,item_3PL-method}
\alias{calcLocation,item_3PL,numeric-method}
\alias{calcLocation,item_PC-method}
\alias{calcLocation,item_PC,numeric-method}
\alias{calcLocation,item_GPC-method}
\alias{calcLocation,item_GPC,numeric-method}
\alias{calcLocation,item_GR-method}
\alias{calcLocation,item_GR,numeric-method}
\alias{calcLocation,item_pool-method}
\alias{calcLocation,item_pool,numeric-method}
\alias{calcLocation,pool_cluster-method}
\alias{calcLocation,pool_cluster,numeric-method}
\title{Calculate item location}
\usage{
calcLocation(object)

\S4method{calcLocation}{item_1PL}(object)

\S4method{calcLocation}{item_2PL}(object)

\S4method{calcLocation}{item_3PL}(object)

\S4method{calcLocation}{item_PC}(object)

\S4method{calcLocation}{item_GPC}(object)

\S4method{calcLocation}{item_GR}(object)

\S4method{calcLocation}{item_pool}(object)

\S4method{calcLocation}{pool_cluster}(object)
}
\arguments{
\item{object}{An instance of an item class.}
}
\value{
Item location values.
}
\description{
An S4 generic and its methods to calculate item location.
}
\examples{
item_1       <- new("item_1PL", difficulty = 0.5)
theta_item_1 <- calcLocation(item_1)
item_2       <- new("item_2PL", slope = 1.0, difficulty = 0.5)
theta_item_2 <- calcLocation(item_2)
item_3       <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
theta_item_3 <- calcLocation(item_3)
item_4       <- new("item_PC", threshold = c(-1, 0, 1), ncat = 4)
theta_item_4 <- calcLocation(item_4)
item_5       <- new("item_GPC", slope = 1.2, threshold = c(-0.8, -1.0, 0.5), ncat = 4)
theta_item_5 <- calcLocation(item_5)
item_6       <- new("item_GR", slope = 0.9, category = c(-1, 0, 1), ncat = 4)
theta_item_6 <- calcLocation(item_6)
theta_itempool <- calcLocation(itempool_science)
}
\references{
{
  \insertRef{rasch_probabilistic_1960}{TestDesign}
}

{
  \insertRef{lord_theory_1952}{TestDesign}

  \insertRef{birnbaum_efficient_1957}{TestDesign}

  \insertRef{birnbaum_estimation_1958}{TestDesign}

  \insertRef{birnbaum_further_1958}{TestDesign}
}

{
  \insertRef{birnbaum_latent_1968}{TestDesign}
}

{
  \insertRef{masters_rasch_1982}{TestDesign}

  \insertRef{andrich_rating_1978}{TestDesign}
}

{
  \insertRef{muraki_generalized_1992}{TestDesign}
}

{
  \insertRef{samejima_estimation_1969}{TestDesign}
}
}
