% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TernaryPlot.R
\name{TernaryPlot}
\alias{TernaryPlot}
\alias{HorizontalGrid}
\title{Create a ternary plot}
\usage{
TernaryPlot(
  atip = NULL,
  btip = NULL,
  ctip = NULL,
  alab = NULL,
  blab = NULL,
  clab = NULL,
  lab.offset = 0.16,
  lab.col = NULL,
  point = "up",
  clockwise = TRUE,
  xlim = NULL,
  ylim = NULL,
  lab.cex = 1,
  lab.font = 0,
  tip.cex = lab.cex,
  tip.font = 2,
  tip.col = "black",
  isometric = TRUE,
  atip.rotate = NULL,
  btip.rotate = NULL,
  ctip.rotate = NULL,
  atip.pos = NULL,
  btip.pos = NULL,
  ctip.pos = NULL,
  padding = 0.08,
  col = NA,
  panel.first = NULL,
  panel.last = NULL,
  grid.lines = 10,
  grid.col = "darkgrey",
  grid.lty = "solid",
  grid.lwd = par("lwd"),
  grid.minor.lines = 4,
  grid.minor.col = "lightgrey",
  grid.minor.lty = "solid",
  grid.minor.lwd = par("lwd"),
  axis.lty = "solid",
  axis.labels = TRUE,
  axis.cex = 0.8,
  axis.font = par("font"),
  axis.rotate = TRUE,
  axis.pos = NULL,
  axis.tick = TRUE,
  axis.lwd = 1,
  ticks.lwd = axis.lwd,
  ticks.length = 0.025,
  axis.col = "black",
  ticks.col = grid.col,
  ...
)

HorizontalGrid(
  grid.lines = 10,
  grid.col = "grey",
  grid.lty = "dotted",
  grid.lwd = par("lwd"),
  direction = getOption("ternDirection", 1L)
)
}
\arguments{
\item{atip, btip, ctip}{Character string specifying text to title corners,
proceeding clockwise from the corner specified in \code{point} (default: top).}

\item{alab, blab, clab}{Character string specifying text with which to label
the corresponding sides of the triangle.
Left or right-pointing arrows are produced by
typing \verb{\\\\U2190} or \verb{\\\\U2192}, or using \code{expression('value' \%->\% '')}.}

\item{lab.offset}{Numeric specifying distance between midpoint of axis label
and the axis.
Increase \code{padding} if labels are being clipped.
Use a vector of length three to specify a different offset for each label.}

\item{lab.col}{Character vector specifying colours for axis labels. Use a
vector of length three to specify a different colour for each label.}

\item{point}{Character string specifying the orientation of the ternary plot:
should the triangle point \code{"up"}, \code{"right"}, \code{"down"} or \code{"left"}?
The integers 1 to 4 can be used in place of the character strings.}

\item{clockwise}{Logical specifying the direction of axes.  If \code{TRUE} (the
default), each axis runs from zero to its maximum value in a clockwise
direction around the plot.}

\item{xlim, ylim}{Numeric vectors of length 2 specifying the minimum and maximum
\emph{x} and \emph{y} limits of the plotted area, to which \code{padding} will be added.
The default is to display the complete height or width of the plot.
Allows cropping to magnified region of the plot. (See vignette for diagram.)
May be overridden if \code{isometric=TRUE}; see documentation of
\code{isometric} parameter.}

\item{lab.cex, tip.cex}{Numeric specifying character expansion (font size)
for axis labels.
Use a vector of length three to specify a different value for each direction.}

\item{lab.font, tip.font}{Numeric specifying font style (Roman, bold, italic,
bold-italic) for axis titles.
Use a vector of length three to set a different font for each direction.}

\item{isometric}{Logical specifying whether to enforce an equilateral shape
for the ternary plot.
If only one of \code{xlim} and \code{ylim} is set, the other will be calculated to
maintain an equilateral plot.
If both \code{xlim} and \code{ylim} are set, but have different ranges, then the limit
with the smaller range will be scaled until its range matches that of the
other limit.}

\item{atip.rotate, btip.rotate, ctip.rotate}{Integer specifying number of
degrees to rotate label of rightmost apex.}

\item{atip.pos, btip.pos, ctip.pos}{Integer specifying positioning of labels,
iff the corresponding \code{xlab.rotate} parameter is set.}

\item{padding}{Numeric specifying size of internal margin of the plot; increase
if axis labels are being clipped.}

\item{col}{The colour for filling the plot; see \code{\link[graphics]{polygon}}.}

\item{panel.first}{An expression to be evaluated after the plot axes are
set up but before any plotting takes place.
This can be useful for drawing backgrounds, e.g. with \code{\link[=ColourTernary]{ColourTernary()}}
or \code{\link[=HorizontalGrid]{HorizontalGrid()}}.
Note that this works by lazy evaluation: passing this argument from other
plot methods may well not work since it may be evaluated too early.}

\item{panel.last}{An expression to be evaluated after plotting has taken
place but before the axes and box are added.  See the comments about
\code{panel.first}.}

\item{grid.lines}{Integer specifying the number of grid lines to plot.}

\item{grid.col, grid.minor.col}{Colours to draw the grid lines. Use a vector
of length three to set different values for each direction.}

\item{grid.lty, grid.minor.lty}{Character or integer vector; line type of
the grid lines. Use a vector of length three to set different values for
each direction.}

\item{grid.lwd, grid.minor.lwd}{Non-negative numeric giving line width of the
grid lines.  Use a vector of length three to set different values for each
direction.}

\item{grid.minor.lines}{Integer specifying the number of minor (unlabelled)
grid lines to plot between each major pair.}

\item{axis.lty}{Line type for both the axis line and tick marks.
Use a vector of length three to set a different value for each direction.}

\item{axis.labels}{This can either be a logical value specifying whether
(numerical) annotations are to be made at the tickmarks, or a character or
expression vector of labels to be placed at the tick points.}

\item{axis.cex}{Numeric specifying character expansion (font size)
for axis labels.
Use a vector of length three to set a different value for each direction.}

\item{axis.font}{Font for text. Defaults to \code{par('font')}.}

\item{axis.rotate}{Logical specifying whether to rotate axis labels
to parallel grid lines, or numeric specifying custom rotation for each axis,
to be passed as \code{srt} parameter to \code{text()}.  Expand margins or set
\code{par(xpd = NA)} if labels are clipped.}

\item{axis.pos}{Vector of length one or three specifying position of axis
labels, to be passed as \code{pos} parameter to \code{text()}; populated automatically
if \code{NULL} (the default).}

\item{axis.tick}{Logical specifying whether to mark the axes with tick marks.}

\item{axis.lwd, ticks.lwd}{Line width for the axis line and tick marks.
Zero or negative values will suppress the line or ticks.
Use a vector of length three to set different values for each axis.}

\item{ticks.length}{Numeric specifying distance that ticks should extend
beyond the plot margin.  Also affects position of axis labels, which are
plotted at the end of each tick.
Use a vector of length three to set a different length for each direction.}

\item{axis.col, ticks.col, tip.col}{Colours for the axis line,
tick marks and tip labels respectively.
Use a vector of length three to set a different value for each direction.
\code{axis.col = NULL} means to use \code{par('fg')}, possibly specified
inline, and \code{ticks.col = NULL} means to use whatever colour
\code{axis.col} resolved to.}

\item{\dots}{Additional parameters to \code{\link[graphics]{plot}}.}

\item{direction}{(optional) Integer specifying the direction that the current ternary plot
should point: 1, up; 2, right; 3, down; 4, left.}
}
\description{
Create and style a blank ternary plot.
}
\details{
The plot will be generated using the standard 'graphics' plot functions, on
which additional elements can be added using cartesian coordinates, perhaps
using functions such as \code{\link[graphics]{arrows}},
\code{\link[graphics]{legend}} or \code{\link[graphics]{text}}.
}
\section{Functions}{
\itemize{
\item \code{HorizontalGrid}: Add \code{grid.lines} horizontal lines to the ternary plot
}}

\examples{
TernaryPlot(atip = "Top", btip = "Bottom", ctip = "Right", axis.col = "red", 
            col = rgb(0.8, 0.8, 0.8))
HorizontalGrid(grid.lines = 2, grid.col = 'blue', grid.lty = 1) 
# the second line corresponds to the base of the triangle, and is not drawn
}
\seealso{
\itemize{
\item \code{\link[=AddToTernary]{AddToTernary()}}: Add elements to a ternary plot
\item \code{\link[=TernaryCoords]{TernaryCoords()}}: Convert ternary coordinates to Cartesian (\emph{x} and \emph{y})
coordinates
\item \code{\link[=TernaryXRange]{TernaryXRange()}}, \code{\link[=TernaryYRange]{TernaryYRange()}}: What are the \emph{x} and \emph{y} limits
of the plotted region?
}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
