% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TernaryPlot.R
\name{AddToTernary}
\alias{AddToTernary}
\alias{TernaryArrows}
\alias{TernaryLines}
\alias{TernaryPoints}
\alias{TernaryPolygon}
\alias{TernaryText}
\alias{JoinTheDots}
\title{Add elements to ternary plot}
\usage{
AddToTernary(PlottingFunction, coordinates, ...)

TernaryArrows(fromCoordinates, toCoordinates = fromCoordinates, ...)

TernaryLines(coordinates, ...)

TernaryPoints(coordinates, ...)

TernaryPolygon(coordinates, ...)

TernaryText(coordinates, ...)

JoinTheDots(coordinates, ...)
}
\arguments{
\item{PlottingFunction}{Function to add data to a plot; perhaps one of
\code{\link[graphics]{points}},
\code{\link[graphics]{lines}} or
\code{\link[graphics]{text}}.}

\item{coordinates}{A list, matrix, data.frame or vector in which each
element (or row) specifies
the three coordinates of a point in ternary space.}

\item{\dots}{Additional parameters to pass to \code{PlottingFunction()}.
If using \code{TernaryText()}, this will likely include the parameter \code{labels},
to specify the text to plot.}

\item{fromCoordinates, toCoordinates}{For \code{TernaryArrows()}, coordinates at
which arrows should begin and end; \emph{cf.} \code{x0}, \code{y0}, \code{x1} and \code{y1} in
\link[graphics]{arrows}.  Recycled as necessary.}
}
\description{
Plot shapes onto a ternary diagram created with \code{\link[=TernaryPlot]{TernaryPlot()}}.
}
\section{Functions}{
\itemize{
\item \code{TernaryArrows}: Add  \link[graphics]{arrows}

\item \code{TernaryLines}: Add \link[graphics]{lines}

\item \code{TernaryPoints}: Add \link[graphics]{points}

\item \code{TernaryPolygon}: Add \link[graphics:polygon]{polygons}

\item \code{TernaryText}: Add \link[graphics]{text}

\item \code{JoinTheDots}: Add points, joined by lines
}}

\examples{
coords <- list(
  A = c(1, 0, 2),
  B = c(1, 1, 1),
  C = c(1.5, 1.5, 0),
  D = c(0.5, 1.5, 1)
)
TernaryPlot()
AddToTernary(lines, coords, col='darkgreen', lty='dotted', lwd=3)
TernaryLines(coords, col='darkgreen')
TernaryArrows(coords[1], coords[2:4], col='orange', length=0.2, lwd=1)
TernaryText(coords, cex=0.8, col='red', font=2)
TernaryPoints(coords, pch=1, cex=2, col='blue')
AddToTernary(points, coords, pch=1, cex=3)


}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
