% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tDWT.R
\name{tDWT}
\alias{tDWT}
\title{Discrete Wavelet Transform}
\usage{
tDWT(tnsr)
}
\arguments{
\item{tnsr, }{A 3-mode Tensor}
}
\value{
S3 class tensor
}
\description{
Performs the Discrete Wavelet Transform of a 3-mode Tensor.
}
\examples{
T <- t_rand(modes=c(2,3,4))
print(tDWT(T))
}
\references{
G. Strang and T. Nguyen, Wavelets and filter banks. SIAM, 1996. A. Haar, "Zur theorie der orthogonalen funktionensysteme", Mathematische annalen, vol. 69, no. 3, pp. 331-371, 1910.

Jensen, A., & la Cour-Harbo, A. (2011). Ripples in mathematics: the discrete wavelet transform. Springer Science & Business Media.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
