% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fitting.R
\name{FitParaSurv}
\alias{FitParaSurv}
\title{Fit Parametric Survival Distribution}
\usage{
FitParaSurv(
  data,
  beta_lower = 0.1,
  beta_upper = 10,
  dist = "weibull",
  eps = 1e-06,
  init = NULL,
  maxit = 10,
  report = FALSE,
  sig = 0.05,
  status_name = "status",
  tau = NULL,
  time_name = "time"
)
}
\arguments{
\item{data}{Data.frame containing the time to event and status.}

\item{beta_lower}{If dist="gen-gamma", lower limit on possible values for beta.}

\item{beta_upper}{If dist="gen-gamma", upper limit on possible values for beta.}

\item{dist}{String, distribution to fit, selected from among: exp, gamma, gen-gamma
log-normal, and weibull.}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{init}{List of initial parameters. See individual distributions for the
expected parameters.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}

\item{sig}{Significance level, for CIs.}

\item{status_name}{Name of the status indicator, 1 if observed, 0 if censored.}

\item{tau}{Optional truncation time for calculating RMSTs.}

\item{time_name}{Name of column containing the time to event.}
}
\value{
An object of class \code{fit} containing the following:
\describe{
  \item{Parameters}{The estimated shape and rate parameters.}
  \item{Information}{The observed information matrix.}
  \item{Outcome}{The fitted mean, median, and variance.}
 \item{RMST}{The estimated RMSTs, if tau was specified.}
}
}
\description{
Estimates parametric survival distributions using event times subject to
non-informative right censoring. Available distributions include:
exponential, gamma, generalized gamma, log-normal, and Weibull.
}
\examples{
# Generate Gamma data with 20\% censoring.
data <- GenData(n = 1e3, dist = "gamma", theta = c(2, 2), p = 0.2)
# Fit gamma distribution.
fit <- FitParaSurv(data, dist = "gamma")

# Generate Weibull data with 10\% censoring.
data <- GenData(n = 1e3, dist = "weibull", theta = c(2, 2), p = 0.1)
# Fit weibull distribution, calculate RMST at tau=0.5.
fit <- FitParaSurv(data, dist = "weibull", tau = 0.5)
}
\seealso{
\itemize{
  \item{Between group comparison of survival experience \code{\link{CompParaSurv}}}
  \item{Exponential distribution \code{\link{FitExp}}}
  \item{Gamma distribution \code{\link{FitGamma}}}
  \item{Generalized gamma distribution \code{\link{FitGenGamma}}}
  \item{Log-normal distribution \code{\link{FitLogNormal}}}
  \item{Weibull distribution \code{\link{FitWeibull}}}
}
}
