% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{binaryQuantileSearch}
\alias{binaryQuantileSearch}
\title{Quantiles of a distribution.}
\usage{
binaryQuantileSearch(pDistFunc, p, lastLeft, lastRight, error = 10^-4)
}
\arguments{
\item{pDistFunc}{a cumulative distribution function on the real numbers, it
should take a single argument x and return the cumualtive distribution
function evaluated at x.}

\item{p}{the quantile \eqn{p\in[0,1]}}

\item{lastLeft}{binary search works by continuously decreasing the search
space from the left and right. lastLeft should be a lower bound for
the quantile p.}

\item{lastRight}{similar to lastRight but should be an upper bound.}

\item{error}{the error tolerated from the binary search}
}
\value{
the quantile (within error).
}
\description{
Computes the pth quantile of a cumulative distribution function using a
simple binary serach algorithm. This can be extremely slow but has the
benefit of being trivial to implement.
}

