% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{volfaodlt7}
\alias{volfaodlt7}
\title{Data: Volume (cbm over bark) according to FAO definition for trees with
dbh less than 7cm}
\format{
A two-dimensional array.
}
\source{
Riedel et al. 2017, table 5.6, p. 35
}
\usage{
volfaodlt7
}
\description{
This data keeps the volume according to FAO definition in cubic meter
including bark for trees with dbh < 7cm. Data discriminates according to
species and diameter class (class mid at 25mm, 55mm and 65mm).
}
\examples{
data(volfaodlt7)
dim(volfaodlt7)
dbhclass <- 3 # classified diameter in breast height, i.e. 3=50-60mm
sp <- 10 # species code
volfaodlt7[BaMap(sp, 8), 3]
}
\references{
Riedel et al 2017: Die Dritte Bundeswaldinventur BWI 2012,
Inventur und Auswertemethoden, Eberswalde November 2017.
}
\keyword{datasets}
