% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TFVInitCons.R
\name{TFVInitCons}
\alias{TFVInitCons}
\title{Generate a TFV initial conditions file from point observations}
\usage{
TFVInitCons(
  file,
  fgdb,
  initialvaluesfile,
  outputfile,
  cellsize = 50,
  ncell = 50000
)
}
\arguments{
\item{file}{.2dm mesh used to generate the cell IDs and centres}

\item{fgdb}{Shape file (.shp and associated .prj) for zones to be preserved}

\item{initialvaluesfile}{csv file with observed data to interpolate}

\item{outputfile}{file to write the initial conditions to}

\item{cellsize}{size of cells to interpolate the observations onto}

\item{ncell}{number of cells to interpolate the observations onto}
}
\value{
Nothing is returned to the environment, with the initial conditions generated written to outputfile. Summary metrics are printed to screen to allows for some quick QA
}
\description{
Generate a TFV initial conditions file from point observations
}
\details{
The shapefile should be a polygon shape file, with different zones to interpolate within. This can be useful to ensure
interpolations are physically sensible, for example where there is a barrier between fresh and saline water, or a
storage above a lower river. Projections are not handled by this function, so the shapefile should be in the same projection as the mesh.

The initialvaluesfile should have at least 6 columns of information:
\itemize{
\item{Column 1 as point index}
\item{Column 2 and 3, columns named "X" and "Y",
with the coordinates of the point observation, in the same projection as the mesh.}
\item{Columns 4 and 5 are reserved for point information, e.g. a station number and station name.
 These are not used, but all for context to be documented, and helpful and if the same csv file is also used for specifying locations in a points output block in the model .fvc file.}
\item{Columns 6 and beyond should be values and will be interpolated. Each column will be interpolated for each zone,
allowing for multiple initial conditions. The column name should match the model scalar (e.g. H, SAL, TEMP, trace_1)}
}

cellsize and ncell are used to specify the resolution of the interpolation. ncell is in units of the mesh coordinates, e.g. m or degrees

interpolation is undertaken using inverse distance weighting from the gstat package, with the default weighting power of 2.
}
\examples{
\dontrun{
file="001_RM_Wetlands_LL_Coorong_MZ.2dm"
fgdb<-"Zones/Zones.shp"
initialvaluesfile<-"CLLMMInitialValues2019.csv"
outputfile<-pate0(tempdir(),"/Initcons2021.csv")
TFVInitCons(file,fgdb,initialvaluesfile,outputfile)
}

}
