% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_functions.R
\name{ts_grid}
\alias{ts_grid}
\title{Tuning Time Series Forecasting Models Parameters with Grid Search}
\usage{
ts_grid(ts.obj, model, optim = "MAPE", periods, window_length = NULL,
  window_space, window_test, hyper_params, parallel = TRUE,
  n.cores = "auto")
}
\arguments{
\item{ts.obj}{A univariate time series object of a class "ts"}

\item{model}{A string, defines the model}

\item{optim}{A string, set the optimization method - c("MAPE", "RMSE")}

\item{periods}{A string, set the number backtesting periods}

\item{window_length}{An integer, defines the length of the backtesting training window.
If set to NULL (default) will use an expending window starting the from the first observation,
 otherwise will use a sliding window.}

\item{window_space}{An integer, set the space length between each of the backtesting training partition}

\item{window_test}{An integer, set the length of the backtesting testing partition}

\item{hyper_params}{A list, defines the tuning parameters and their range}

\item{parallel}{Logical, if TRUE use multiple cores in parallel}

\item{n.cores}{Set the number of cores to use if the parallel argument is set to TRUE.}
}
\value{
A list
}
\description{
Tuning time series models with grid search approach using backtesting method.
 If set to "auto" (default), will use all available cores in the system minus 1
}
\examples{
\dontrun{
 data(USgas)
 
 # Starting with a shallow search (sequence between 0 and 1 with jumps of 0.1)
 # To speed up the process, will set the parallel option to TRUE 
 # to run the search in parallel using 8 cores
 
 hw_grid_shallow <- ts_grid(ts.obj = USgas,
                            periods = 6,
                            model = "HoltWinters",
                            optim = "MAPE",
                            window_space = 6,
                            window_test = 12,
                            hyper_params = list(alpha = seq(0.01, 1,0.1),
                                                beta =  seq(0.01, 1,0.1),
                                                gamma = seq(0.01, 1,0.1)),
                            parallel = TRUE,
                            n.cores = 8)
 
 
 # Use the parameter range of the top 20 models 
 # to set a narrow but more agressive search
 
 a_min <- min(hw_grid_shallow$grid_df$alpha[1:20])
 a_max <- max(hw_grid_shallow$grid_df$alpha[1:20])
 
 b_min <- min(hw_grid_shallow$grid_df$beta[1:20])
 b_max <- max(hw_grid_shallow$grid_df$beta[1:20])
 
 g_min <- min(hw_grid_shallow$grid_df$gamma[1:20])
 g_max <- max(hw_grid_shallow$grid_df$gamma[1:20])
 
 hw_grid_second <- ts_grid(ts.obj = USgas,
                           periods = 6,
                           model = "HoltWinters",
                           optim = "MAPE",
                           window_space = 6,
                           window_test = 12,
                           hyper_params = list(alpha = seq(a_min, a_max,0.05),
                                               beta =  seq(b_min, b_max,0.05),
                                               gamma = seq(g_min, g_max,0.05)),
                           parallel = TRUE,
                           n.cores = 8)
 
 md <- HoltWinters(USgas, 
                   alpha = hw_grid_second$alpha,
                   beta = hw_grid_second$beta,
                   gamma = hw_grid_second$gamma)
 
 library(forecast)
 
 fc <- forecast(md, h = 60)
 
 plot_forecast(fc)

}  
}
