% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_config_chart.R
\name{generate_solution_note}
\alias{generate_solution_note}
\title{Generate solution note for multiple solutions}
\usage{
generate_solution_note(
  n_sol,
  epi_list = NULL,
  style = c("simple", "detailed"),
  language = c("en", "ja"),
  format = c("markdown", "latex")
)
}
\arguments{
\item{n_sol}{Integer. Number of solutions.}

\item{epi_list}{Character vector. Essential prime implicants (NULL to omit).}

\item{style}{Character. \code{"simple"} or \code{"detailed"}.}

\item{language}{Character. \code{"en"} or \code{"ja"}.}

\item{format}{Character. \code{"markdown"} or \code{"latex"}.}
}
\value{
Character string of the note, or empty string if n_sol <= 1.
}
\description{
Creates a note explaining that multiple equivalent solutions exist
and that the displayed configuration is based on M1.
}
\examples{
# Simple note
generate_solution_note(2, style = "simple")

# Detailed note with EPIs
generate_solution_note(3, epi_list = c("A*B", "C"), style = "detailed")

# Japanese
generate_solution_note(2, style = "simple", language = "ja")

}
