% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSMining.R
\name{Func.dist}
\alias{Func.dist}
\title{A function to calculate the distance between two SAX representations}
\usage{
Func.dist(x, y, mat, n)
}
\arguments{
\item{x}{is a SAX representations.}

\item{y}{is a SAX representations. It should have the same length as x.}

\item{mat}{is the distance matrix created by \code{Func.matrix}}

\item{n}{is the length of the original time series before the SAX transformation}
}
\value{
The function returns a numeric value, which is the distance between two SAX representations
}
\description{
This function calculates the distance between two SAX representations
}
\examples{
#Assuming the original time series has a length of 20, n=20
#Assuming the time series is transformed into SAX representations using w=4 and a=4
#Assuming one is a,b,c,d and the other is d,b,c,d
Func.dist(x=c("a","b","c","d"), y=c("d","b","c","d"), mat=Func.matrix(a=4), n=20)
}

