% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxFuncts.R
\name{generateStepDiscrim}
\alias{generateStepDiscrim}
\title{Generate StepDiscrim from raw data}
\usage{
generateStepDiscrim(
  XSeries,
  grps,
  f,
  maxvars,
  VStep,
  lev = 0,
  features = c("Var", "Cor", "IQR", "PE", "DM"),
  nCores = 0
)
}
\arguments{
\item{XSeries}{Sample from the population (dim x length x cases)}

\item{grps}{Labeled vector that classify the observations}

\item{f}{Selected filter for the MODWT (to see the available filters use the
function \code{\link{availableFilters}}}

\item{maxvars}{Maximum number of variables included by the StepDiscrim
algorithm (Note that if you defined this, can not define VStep). Must
be a positive integer}

\item{VStep}{Minimum value of V above which all other variables are
considered irrelevant and therefore will not be included. (Note that
if you defined this, can not defined maxvars).Must be a positive
number. For more information see StepDiscrim documentation.}

\item{lev}{Determines the number of decomposition levels for MODWT
(by default the optimum is calculated). Must be a positive integer,
where 0 corresponds to the default behavior.}

\item{features}{A list of characteristics that will be used for the
classification process. To see the available features see
\code{\link{availableFeatures}}}

\item{nCores}{Determines the number of processes that will be used in the
function, by default it uses all but one of the system cores.
Must be a positive integer, where 0 corresponds to the default
behavior}
}
\value{
A MultiWaveAnalysis with the most discriminant variables based on the
features indicated.
}
\description{
This function allows to obtain in a single step the complete WaveAnalysis
and the selection of the most discriminating variables of the WaveAnalysis.
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
# The dataset has the first 5 elements of class 1
# and the last 5 of class 2.
grps <- c(rep(1, 5), rep(2, 5))
MWADiscrim <- generateStepDiscrim(ECGExample, grps, "haar",
  features = c("Var"), maxvars = 5
)
# or using the VStep option
MWADiscrim <- generateStepDiscrim(ECGExample, grps, "haar",
 features = c("Var", "Cor"), VStep = 0.7
)
}
}
\seealso{
\itemize{
\item \code{\link{MultiWaveAnalysis}}
\item \code{\link{StepDiscrim}}
\item \code{\link{StepDiscrimV}}
}
}
