## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(TPMplt)
head(TPMdata[,1:3])


## -----------------------------------------------------------------------------
colnames(TPMdata)

## -----------------------------------------------------------------------------
require(VBTree)
dl2vbt(chrvec2dl(colnames(TPMdata)))

## ----fig.show='hide'----------------------------------------------------------
Fitted_data <- KFprocess(TPMdata, dV = 0.3, dW = 0.006)
SSplots(Fitted_data, 2, mfrow=c(2, 2))

## ----fig.show='hide'----------------------------------------------------------
TCorrect_data <- TCorrect(TPMdata, 2, 3, 0.9, 7.8, 502.416, seq(0, 0.9, 0.02))
SSplots(TCorrect_data, 2, mfrow=c(2, 2))

## -----------------------------------------------------------------------------
epstable <- epsExtract(TCorrect_data, eps = 0.7, lyT = 2, lySR = 3)
epstable

## -----------------------------------------------------------------------------
DMM <- DMMprocess(epstable)
DMM

## -----------------------------------------------------------------------------
DMM <- DMMprocess(epstable, ConsFunc = TRUE)

## -----------------------------------------------------------------------------
PLTbd <- SVRModel(DMM)

## ----fig.show='hold', fig.height=4, fig.width=6-------------------------------
TPM2dplt(PLTbd)

## -----------------------------------------------------------------------------
TPM3dplt(PLTbd)

