% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap_plot.R
\name{umap_plot}
\alias{umap_plot}
\title{UMAP plot for analyzing and visualizing UMAP algorithm.}
\usage{
umap_plot(
  sample_gene,
  group_sample,
  seed = 1,
  multi_shape = TRUE,
  point_size = 5,
  point_alpha = 1,
  text_size = 5,
  text_alpha = 0.8,
  fill_alpha = 0,
  border_alpha = 0,
  sci_fill_color = "Sci_AAAS",
  legend_pos = "right",
  legend_dir = "vertical",
  ggTheme = "theme_light"
)
}
\arguments{
\item{sample_gene}{Dataframe: gene expression dataframe (1st-col: Transcripts or Genes, 2nd-col~: Samples).}

\item{group_sample}{Dataframe: Samples and groups for gene expression (1st-col: Samples, 2nd-col: Groups).}

\item{seed}{Numeric: set seed for robust result. Default: 1.}

\item{multi_shape}{Logical: groups as shapes. Default: FALSE, options: TRUE, FALSE.}

\item{point_size}{Numeric: point size. Default: 5, min: 0, max: null.}

\item{point_alpha}{Numeric: point color alpha. Default: 0.80, min: 0.00, max: 1.00.}

\item{text_size}{Numeric: text size. Default: 5, min: 0 (hind), max: null.}

\item{text_alpha}{Numeric: text alpha. Default: 0.80, min: 0.00, max: 1.00.}

\item{fill_alpha}{Numeric: ellipse alpha. Default: 0.30, min: 0.00, max: 1.00.}

\item{border_alpha}{Numeric: ellipse border color alpha. Default: 0.10, min: 0.00, max: 1.00.}

\item{sci_fill_color}{Character: ggsci color pallet. Default: "Sci_AAAS", options: "Sci_AAAS", "Sci_NPG", "Sci_Simpsons", "Sci_JAMA", "Sci_GSEA", "Sci_Lancet", "Sci_Futurama", "Sci_JCO", "Sci_NEJM", "Sci_IGV", "Sci_UCSC", "Sci_D3", "Sci_Material".}

\item{legend_pos}{Character: legend position. Default: "right", options: "none", "left", "right", "bottom", "top".}

\item{legend_dir}{Character: legend direction. Default: "vertical", options: "horizontal", "vertical".}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void"}
}
\value{
Plot: UMAP plot for analyzing and visualizing UMAP algorithm.
}
\description{
UMAP plot for analyzing and visualizing UMAP algorithm.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_expression)
head(gene_expression)

data(samples_groups)
head(samples_groups)

# 3. Default parameters
umap_plot(gene_expression, samples_groups)

# 4. Set sci_fill_color = "Sci_Simpsons", seed = 6
umap_plot(gene_expression, samples_groups, sci_fill_color = "Sci_Simpsons", seed = 6)

# 5. Set fill_alpha = 0.10
umap_plot(gene_expression, samples_groups, fill_alpha = 0.10)

}
\author{
benben-miao
}
