% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_compare_smd.R
\name{boot_compare_smd}
\alias{boot_compare_smd}
\title{Comparing SMDs between independent studies with Bootstrapping}
\usage{
boot_compare_smd(
  x1,
  y1 = NULL,
  x2,
  y2 = NULL,
  null = 0,
  paired = FALSE,
  alternative = c("two.sided", "less", "greater"),
  R = 1999,
  alpha = 0.05
)
}
\arguments{
\item{x1}{a (non-empty) numeric vector of data values from study 1.}

\item{y1}{an optional (non-empty) numeric vector of data values from study 1.}

\item{x2}{a (non-empty) numeric vector of data values from study 2.}

\item{y2}{an optional (non-empty) numeric vector of data values from study 2.}

\item{null}{a number indicating the null hypothesis. For TOST, this would be equivalence bound.}

\item{paired}{a logical indicating whether the SMD is from a paired or independent samples design.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{R}{number of bootstrap replicates}

\item{alpha}{alpha level (default = 0.05)}
}
\value{
A list with class "htest" containing the following components:
\describe{
  \item{\code{"statistic"}}{z-score}
  \item{\code{"p.value"}}{numeric scalar containing the p-value for the test under the null hypothesis.}
  \item{\code{"estimate"}}{difference in SMD between studies}
  \item{\code{"conf.int"}}{percentile (bootstrap) confidence interval for difference in SMDs}
  \item{\code{"null.value"}}{the specified hypothesized value for the null hypothesis.}
  \item{\code{"alternative"}}{character string indicating the alternative hypothesis (the value of the input argument alternative). Possible values are "greater", "less", or "two-sided".}
  \item{\code{"method"}}{Type of SMD}
  \item{\code{"data.name"}}{"Boostrapped" to denote summary statistics were utilized to obtain results.}
  \item{\code{"smd"}}{SMDs input for the function.}
  \item{\code{"df_ci"}}{Data frame of confidence intervals.}
  \item{\code{"boot_res"}}{List of bootstrapped results.}
  \item{\code{"call"}}{the matched call.}
}
}
\description{
A function to compare standardized mean differences (SMDs) between studies. This function is intended to be used to compare the compatibility of original studies with replication studies (lower p-values indicating lower compatibility)
}
\seealso{
Other compare studies: 
\code{\link{compare_smd}()}
}
\concept{compare studies}
