% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMB.R
\name{compile}
\alias{compile}
\title{Compile a C++ template to DLL suitable for MakeADFun.}
\usage{
compile(file, flags = "", safebounds = TRUE, safeunload = TRUE,
  openmp = isParallelTemplate(file[1]), libtmb = TRUE, libinit = TRUE,
  tracesweep = FALSE, ...)
}
\arguments{
\item{file}{C++ file.}

\item{flags}{Character with compile flags.}

\item{safebounds}{Turn on preprocessor flag for bound checking?}

\item{safeunload}{Turn on preprocessor flag for safe DLL unloading?}

\item{openmp}{Turn on openmp flag? Auto detected for parallel templates.}

\item{libtmb}{Use precompiled TMB library if available (to speed up compilation)?}

\item{libinit}{Turn on preprocessor flag to register native routines?}

\item{tracesweep}{Turn on preprocessor flag to trace AD sweeps? (Silently disables \code{libtmb})}

\item{...}{Passed as Makeconf variables.}
}
\description{
Compile a C++ template into a shared object file. OpenMP flag is set if the template is detected to be parallel.
}
\details{
TMB relies on R's built in functionality to create shared libraries independent of the platform.
A template is compiled by \code{compile("template.cpp")}, which will call R's makefile with appropriate
preprocessor flags.
Compiler and compiler flags can be stored in a configuration file. In order of precedence either via
the file pointed at by R_MAKEVARS_USER or the file ~/.R/Makevars if it exists.
Additional configuration variables can be set with the \code{flags} and \code{...} arguments, which will override any
previous selections.
}
\seealso{
\code{\link{precompile}}
}

