% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script_TL.SAR.R
\name{script_TL.SAR}
\alias{script_TL.SAR}
\title{Easy script for the SAR protocol}
\usage{
script_TL.SAR(file.name, eval.Tmin, eval.Tmax, relative.error = 0.05,
  remove.discs = NULL, file.parameters = list(file.extension = ".binx",
  folder.in = "./", folder.out = "./"), aligning.parameters = list(peak.Tmin =
  NULL, peak.Tmax = NULL, no.testdose = FALSE),
  fitting.parameters = list(fit.method = "LIN", fit.weighted = FALSE,
  fit.rDoses.min = 0, fit.rDoses.max = NA),
  plotting.parameters = list(plot.Tmin = 0, plot.Tmax = NA, no.plot = FALSE),
  rejection.criteria = list(recycling.ratio = 10, recuperation.rate = 10,
  testdose.error = 10, paleodose.error = 10))
}
\arguments{
\item{file.name}{\link{character} (\bold{required}): Name of the file containing the luminescence data.}

\item{eval.Tmin}{\link{integer} (\bold{required}): Temperature ( °C) of the lower boundary for the signal integration.}

\item{eval.Tmax}{\link{integer} (\bold{required}): Temperature (°C) of the upper boundary for the signal integration.}

\item{relative.error}{\link{numeric} (with default): Relative error of the TL signals.}

\item{remove.discs}{\link{numeric}  (with default): list containing the position of the aliquots that shall be removed}

\item{file.parameters}{\link{list} (with default): list containing the input/output parameters. See details.}

\item{aligning.parameters}{\link{list} (with default): list containing the aligning parameters. See details.}

\item{fitting.parameters}{\link{list} (with default): list containing the fitting parameters. See details.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}

\item{rejection.criteria}{\link{list} (with default): list containing the rejection criteria (in \%). See details.}
}
\value{
This function plots the results from the differents functions called using:
 \link{plot_extract.TL},
 \link{plot_remove.preheat}
 \link{plot_substract.background}
 \link{plot_align.peaks} and
 \link{plot_TL.SAR}. \cr

 This function saves a  file containing the luminescence data after the pretreatment in the specified folder.

 Finally, it also provides an \link{list} containing: \cr
 \describe{
   \item{\code{De.GC}}{
     \link{list}: Results obtained with the dose plateau approach and their uncertainties
     (\code{De}, \code{De.error})}
   \item{\code{De.DP}}{
     \link{list}: Results obtained with the growth curve approach and their uncertainties
     (\code{De}, \code{De.error})}
 }
}
\description{
This function provides and estimation of the ED using the SAR protocol.
It only requires the name of the files with the TL curves, the relative error on the measurements and the temperature boundaries for the signal integration.
Extra parameters can  be provided to improve the ED estimation.
}
\details{
\bold{File parameters} \cr
The file parameters are:  \cr
\describe{
 \item{\code{file.extension}}{
   \link{character} (with default): extension of the file containing the luminescence data (.bin or .binx)}
 \item{\code{folder.in}}{
   \link{character} (with default): Folder containing the file with the luminescene data.}
 \item{\code{folder.out}}{
   \link{character} (with default): Folder containing the file with the new luminescene data.}
}
see also \link{script_TL.pretreatment}.

 \bold{Aligning parameters} \cr
 The aligning parameters are:  \cr
 \describe{
 \item{\code{peak.Tmin}}{
   \link{numeric}: Lower boundary for looking for the peak maximum position.}
 \item{\code{peak.Tmax}}{
   \link{numeric}: Upper boundary for looking for the peak maximum position.}
 \item{\code{no.testdose}}{
   \link{logical}: If \code{TRUE}, the function will use the Lx curves rather the Tx curves as reference for the peak maximum position.}
 }
\bold{Rejection criteria} \cr
The rejection criteria are: \cr
\describe{
 \item{\code{recycling.ratio}}{
   \link{numeric}: Maximum recycling ratio accepted (in \%).}
 \item{\code{recuperation.rate}}{
   \link{numeric}: Maximum recuparation rate accepted (in \%).}
 \item{\code{paleodose.error}}{
   \link{numeric}: Maximum error accepted on the regenative signals (in \%).}
 \item{\code{testdose.error}}{
   \link{numeric}: Maximum error accepted on the testdose signals (in \%).}
 }

\bold{Fitting parameters} \cr
The fitting parameters are:  \cr
\describe{
 \item{\code{method}}{
   \link{character}: Fitting method (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).}
 \item{\code{fit.weighted}}{
   \link{logical}: If the fitting is weighted or not.}
 \item{\code{fit.rDoses.min}}{
   \link{numeric}: Lowest regenerative dose used for the fitting.}
 \item{\code{fit.rDoses.max}}{
   \link{numeric}: Highest regenerative dose used for the fitting.}
}
See also \link{calc_TL.SAR.fit}. \cr

\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lower temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: Higher temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{plot_TL.SAR}. \cr
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{read_BIN2R},
 \link{Risoe.BINfileData2TLum.BIN.File},
 \link{mod_extract.TL},
 \link{mod_update.dType},
 \link{mod_remove.aliquot},
 \link{mod_remove.preheat},
 \link{mod_substract.background},
 \link{mod_align.peaks},
 \link{write_R2BIN},
 \link{TLum.BIN.File2TLum.Analysis} and
 \link{analyse_TL.SAR}.
}

