% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_members.R
\name{show_collection_def}
\alias{show_collection_def}
\title{Show the definition of a collection}
\usage{
show_collection_def(collection, silent = FALSE)
}
\arguments{
\item{collection}{a json string with the collection definition as returned
by \code{\link[=get_local_collection]{get_local_collection()}}}

\item{silent}{a logical indicating if the definition should be written
(TRUE by default) or not.}
}
\value{
A list with:
\itemize{
\item collection \strong{title}
\item collection \strong{description}
\item a list of \strong{arguments} for defining collection members as a list
of elements with:
\itemize{
\item the \strong{type} of the argument element
\item \strong{allowed} values if any
}
}
}
\description{
This function prints details regarding a collection: title, description
and arguments information. These arguments are those that can be
used to document collection members within an \link{MDB} using
the \code{\link[=add_collection_member]{add_collection_member()}} function.
}
\examples{
get_local_collection("BE") \%>\% show_collection_def()

}
