% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.tfisher.R
\name{p.tfisher}
\alias{p.tfisher}
\title{CDF of thresholding Fisher's p-value combination statistic under the null hypothesis.}
\usage{
p.tfisher(q, n, tau1, tau2)
}
\arguments{
\item{q}{- quantile, could be a vector.}

\item{n}{- dimension parameter, i.e. the number of p-values to be combined.}

\item{tau1}{- truncation parameter. 0 < tau1 <= 1.}

\item{tau2}{- normalization parameter. tau2 >= tau1.}
}
\value{
The left-tail probability of the null distribution of thresholding Fisher's p-value combination statistic at the given quantile.
}
\description{
CDF of thresholding Fisher's p-value combination statistic under the null hypothesis.
}
\examples{
pval <- runif(100)
tfstat <- stat.tfisher(p=pval, tau1=0.75, tau2=0.25)
p.tfisher(q=tfstat, n=100, tau1=0.75, tau2=0.25)
}
\references{
1. Hong Zhang and Zheyang Wu. "Optimal Thresholding of Fisher's P-value Combination
Tests for Signal Detection", submitted.
}
\seealso{
\code{\link{stat.tfisher}} for the definition of the statistic.
}
