% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootresampling.R
\name{boot_calib}
\alias{boot_calib}
\title{Bootstrap calibration for single-sample and k-sample tests}
\usage{
boot_calib(x, stdx, stat, B, ...)
}
\arguments{
\item{x}{Symmetric matrix observations. Either a \code{\link{fsm}} or a \code{\link{kfsm}}.}

\item{stdx}{Either a \code{\link{fsm}} or \code{\link{kfsm}} of matrices transformed to satisfy the null hypothesis OR sampling weights for each matrix in \code{x} for weighted bootstrap calibration (sampling weights should be optimised and also generate an empirical distribution that satisfies the null hypothesis).}

\item{stat}{Function to compute the statistic.}

\item{B}{The number of bootstrap samples to use.}

\item{...}{Passed to \code{stat}}
}
\value{
A list of
\itemize{
\item \code{pval} the \code{p}-value from the test
\item \code{t0} the statistic for the observations \code{x}
\item \code{nullt} The statistic evaluated on the resamples
\item \code{stdx} The \code{stdx} passed into \code{boot_calib()}
\item \code{B} The number of resamples requested
\item \code{nullt_messages} Any error messages for the corresponding resample
}

The returned object has a bespoke class \code{TFORGE} for easy use of \code{print()}.
}
\description{
Performs a bootstrap hypothesis test using the supplied statistic.
The \code{stdx} parameter is used to define an empirical distribution that satisfies the null hypothesis.
}
\details{
The function \code{stat} is applied to \code{x} and all resamples, with the result returned in the \code{t0} and \code{nullt} elements of the returned object, respectively.

Errors in evaluating \code{stat} on resamples are recorded in the \code{nullt_messages} and lead to \code{NA} values for the statistic in the \code{nullt} element of the returned object.

The \code{p}-value is the fraction of non-\code{NA} resample statistic values that are greater than \code{stat} applied to \code{x}.
}
