% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_format_names.R
\name{check_format_names}
\alias{check_format_names}
\title{Check format of TDLM's inputs}
\usage{
check_format_names(vectors, matrices = NULL, check = "format_and_names")
}
\arguments{
\item{vectors}{a list of vectors. The list can contain one vector. It is
recommended to name each element of the list. If \code{vectors = NULL} only the
matrices will be considered.}

\item{matrices}{a list of matrices. The list can contain one matrix. It is
recommended to name each element of the list. If \code{matrices = NULL} only the
vectors will be considered (by default).}

\item{check}{a character indicating what types of check
("format" or "format_and_names") should be used (see Details).}
}
\value{
A message indicating if the check has passed or failed.
}
\description{
This function checks that the TDLM's inputs have the required format (an
names).
}
\details{
The \code{TDLM}'s inputs should be based on the same number of
locations sorted in the same order. \code{check = "format"} will run basic checks
to ensure that the structure of the inputs (dimensions, class, type...) is
correct.

It is recommended to use the location ID as vector names, matrix rownames and
matrix colnames. Set \code{check  = "format_and_names"} to check the inputs'
names. The checks are run successively, so run the function as many times as
needed to get the message indicating that the inputs passed the check
successfully.
}
\examples{
data(mass)
data(distance)

mi <- as.numeric(mass[, 1])
names(mi) <- rownames(mass)
mj <- mi

check_format_names(
  vectors = list(mi = mi, mj = mj),
  matrices = list(distance = distance),
  check = "format_and_names"
)

}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
