% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{independence_test}
\alias{independence_test}
\title{Independence test for two groups of persistence diagrams.}
\usage{
independence_test(
  g1,
  g2,
  dims = c(0, 1),
  sigma = 1,
  t = 1,
  num_workers = parallelly::availableCores(omit = 1),
  verbose = FALSE
)
}
\arguments{
\item{g1}{the first group of persistence diagrams, where each diagram was either the output from a persistent homology calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}/\code{\link{PyH}}, or \code{\link{diagram_to_df}}.}

\item{g2}{the second group of persistence diagrams, where each diagram was either the output from a persistent homology calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}/\code{\link{PyH}}, or \code{\link{diagram_to_df}}.}

\item{dims}{a non-negative integer vector of the homological dimensions in which the test is to be carried out, default c(0,1).}

\item{sigma}{a positive number representing the bandwidth for the Fisher information metric, default 1.}

\item{t}{a positive number representing the scale for the persistence Fisher kernel, default 1.}

\item{num_workers}{the number of cores used for parallel computation, default is one less than the number of cores on the machine.}

\item{verbose}{a boolean flag for if the time duration of the function call should be printed, default FALSE}
}
\value{
a list with the following elements:
\describe{

 \item{dimensions}{the input `dims` argument.}
 
 \item{test_statisics}{a numeric vector of the test statistic value in each dimension.}
 
 \item{p_values}{a numeric vector of the p-values in each dimension.}
 
 \item{run_time}{the run time of the function call, containing time units.}

}
}
\description{
Carries out inference to determine if two groups of persistence diagrams are independent or not
based on kernel calculations (see 
(\url{https://proceedings.neurips.cc/paper/2007/file/d5cfead94f5350c12c322b5b664544c1-Paper.pdf}) for details).
A small p-value in a certain dimension suggests that the groups are not independent in that dimension.
}
\details{
The test is carried out with a parametric null distribution, making it much faster than non-parametric
approaches. If all of the diagrams in either g1 or g2 are the same in some dimension, then some p-values may be NaN.
}
\examples{

# create two independent groups of diagrams of length 6, which
# is the minimum length
D1 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                   dim = 0,threshold = 2)
D2 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                   dim = 0,threshold = 2)
g1 <- list(D1,D2,D2,D2,D2,D2)
g2 <- list(D2,D1,D1,D1,D1,D1)

# do independence test with sigma = t = 1 in dimension 0
indep_test <- independence_test(g1,g2,dims = c(0),num_workers = 2)
}
\references{
Gretton A et al. (2007). "A Kernel Statistical Test of Independence." \url{https://proceedings.neurips.cc/paper/2007/file/d5cfead94f5350c12c322b5b664544c1-Paper.pdf}.
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
