% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{get_sop_instance_uids}
\alias{get_sop_instance_uids}
\title{Get SOP instance UIDs (individual DICOM image IDs) for an image series}
\usage{
get_sop_instance_uids(series_instance_uid)
}
\arguments{
\item{series_instance_uid}{Series instance UID. To get a list of available series instance UIDs, call \code{\link{get_series_info}}.}
}
\value{
List containing elements:
\itemize{
  \item \code{sop_instance_uids}: character vector of SOP instance UIDs (individual DICOM image IDs)
  \item \code{content}: parsed API response content
  \item \code{response}: API response
}
}
\description{
Get SOP instance UIDs (individual DICOM image IDs) for an image series
}
\examples{
\dontrun{
get_sop_instance_uids("1.3.6.1.4.1.14519.5.2.1.5382.4002.272234209223992578700978260744")
}

}
\seealso{
\code{\link{get_series_info}},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
