% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{HubbertWindField}
\alias{HubbertWindField}
\title{Hubbert Wind Field}
\usage{
HubbertWindField(f, rMax, vFm, thetaFm, Rlam, V, surface)
}
\arguments{
\item{f}{single coriolis parameter at the centre of TC in hz}

\item{rMax}{radius of maximum winds in km}

\item{vFm}{input forward velocity of TC}

\item{thetaFm}{input forward direction of TC}

\item{Rlam}{two columns for distances and direction from grid points to TC centre in km}

\item{V}{velocity profile}

\item{surface}{equals one if winds are reduced from the gradient level to the surface, otherwise gradient winds.}
}
\value{
array with two columns for zonal and meridional wind speed vector-components.
//@example HubbertWindField(-1e-4,20,2,10,rbind(c(50,35),c(45,40)),c(20,20))
}
\description{
Grid point vortex Wind field, wind vectors. Hubbert, G.D., G.J.Holland, L.M.Leslie and M.J.Manton, 1991: A Real - Time System for Forecasting Tropical Cyclone Storm Surges. *Weather and Forecasting*, **6 * *, 86 - 97
}
\keyword{internal}
