% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGAretr_scr.R
\name{get_clinical_data}
\alias{get_clinical_data}
\title{Retrieve Clinical Information from a TCGA Study}
\usage{
get_clinical_data(case_id = NULL)
}
\arguments{
\item{case_id}{string corresponding to the case_list identifier of a specific list of cases of interest}
}
\value{
data.frame including one row per patient/case/sample
}
\description{
Retrieve Information about the Patients included in a TCGA Study of Interest. 
Each patient is associates with a case_id. Each case_id is accompained by a set 
of clinical information that may include sex, age, therapeutic regimen, Tumor Staging, 
vital status and others. NA are allowed.
}
\examples{
clinic_data <- get_clinical_data("blca_tcga_all")
if (nrow(clinic_data) >= 6 & ncol(clinic_data) >= 5) {
  clinic_data[1:6,1:5]
  hist(as.numeric(clinic_data$AGE), 
  col = "darkorange", 
  xlab = "Age", 
  main = "Bladder Cancer, age of diagnosis")
}

}
\references{
\itemize{
  \item \url{http://www.biotechworld.it/bioinf/2016/07/11/tcga-data-via-tcgaretriever/}
  \item \url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
