% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMP.R
\name{PMP}
\alias{PMP}
\title{Posterior model probability}
\usage{
PMP(fullModel = NULL, candidateModels = NULL, data = NULL,
  discreteSurv = TRUE, method = "LEB", prior = "flat", package = "nnet",
  maxit = 150, numberCores = 1)
}
\arguments{
\item{fullModel}{formula of the model including all potential variables}

\item{candidateModels}{Instead of defining the full model we can also
specify the candidate models whose deviance statistic and d.o.f should be
computed}

\item{data}{the data frame with all the information}

\item{discreteSurv}{Boolean variable telling us whether a 'simple'
multinomial regression is looked for or if the goal is a discrete
survival-time model for multiple modes of failure is needed.}

\item{method}{tells us which method for the definition of g should be
used. Possibilities are: \code{LEB}, \code{GEB}, \code{g=n}, \code{hyperG},
\code{ZS}, \code{ZSadapted} and \code{hyperGN}}

\item{prior}{should a dependent or a flat prior be used on the model space?
Only needed if \code{method = `GEB`}.}

\item{package}{Which package should be used to fit the models; by default
the \code{nnet} package is used; we could also specify to use the package
'VGAM'}

\item{maxit}{Only needs to be specified with package \code{nnet}: maximal
number of iterations}

\item{numberCores}{How many cores should be used in parallel?}
}
\value{
an object of class \code{TBF.ingredients}
}
\description{
This function computes the posterior probability of all candidate models
}
\examples{
# extract the data:
data("VAP_data")

# the definition of the full model with three potential predictors:
FULL <- outcome ~ ns(day, df = 4) + gender + type + SOFA
# here we define time as a spline with 3 knots

# computation of the posterior model probabilities:
test <- PMP(fullModel = FULL, data = VAP_data,
            discreteSurv = TRUE, maxit = 150)
class(test)

}
\author{
Rachel Heyard
}
