% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.bib.R
\name{read.bib}
\alias{read.bib}
\title{Read Metadata Entries}
\usage{
read.bib(file)
}
\arguments{
\item{file}{\file{*.bib} file to parse.}
}
\value{
List of metadata entries.
}
\description{
Read metadata entries written in BibTeX format.
}
\note{
This function was created when the \pkg{bibtex} package was temporarily
removed from CRAN. The current implementation reduces the \pkg{TAF} package
dependencies to base R and nothing else.

This parser is similar to the \code{read.bib} function in the \pkg{bibtex}
package, except:
\itemize{
\item It returns a plain list instead of class \code{bibentry}.
\item The fields \code{bibtype} and \code{key} are stored as list elements
      instead of attributes.
}

See the TAF Wiki page on
\href{https://github.com/ices-taf/doc/wiki/Bib-entries}{bib entries}.
}
\examples{
\dontrun{
bib <- read.bib("DATA.bib")
str(bib)
}

}
\seealso{
\code{\link{taf.boot}} reads and processes metadata entries.

\code{\link{taf.sources}} reads metadata entries and adds a \code{type}
field.

\code{\link{TAF-package}} gives an overview of the package.
}
