% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_wass_sinkhorn.R
\name{sinkhorn}
\alias{sinkhorn}
\alias{sinkhornD}
\title{Wasserstein Distance by Entropic Regularization}
\usage{
sinkhorn(X, Y, p = 2, wx = NULL, wy = NULL, lambda = 0.1, ...)

sinkhornD(D, p = 2, wx = NULL, wy = NULL, lambda = 0.1, ...)
}
\arguments{
\item{X}{an \eqn{(M\times P)} matrix of row observations.}

\item{Y}{an \eqn{(N\times P)} matrix of row observations.}

\item{p}{an exponent for the order of the distance (default: 2).}

\item{wx}{a length-\eqn{M} marginal density that sums to \eqn{1}. If \code{NULL} (default), uniform weight is set.}

\item{wy}{a length-\eqn{N} marginal density that sums to \eqn{1}. If \code{NULL} (default), uniform weight is set.}

\item{lambda}{a regularization parameter (default: 0.1).}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 496).}
\item{abstol}{stopping criterion for iterations (default: 1e-10).}
}}

\item{D}{an \eqn{(M\times N)} distance matrix \eqn{d(x_m, y_n)} between two sets of observations.}
}
\value{
a named list containing\describe{
\item{distance}{\eqn{\mathcal{W}_p} distance value.}
\item{iteration}{the number of iterations it took to converge.}
\item{plan}{an \eqn{(M\times N)} nonnegative matrix for the optimal transport plan.}
}
}
\description{
Due to high computational cost for linear programming approaches to compute
Wasserstein distance, \insertCite{cuturi_sinkhorn_2013;textual}{T4transport} proposed an entropic regularization
scheme as an efficient approximation to the original problem. This comes with
a regularization parameter \eqn{\lambda > 0} in the term
\deqn{\lambda h(\Gamma) = \lambda \sum_{m,n} \Gamma_{m,n} \log (\Gamma_{m,n}).}
As \eqn{\lambda\rightarrow 0},
the solution to an approximation problem approaches to the solution of a
true problem. However, we have an issue with numerical underflow. Our
implementation returns an error when it happens, so please use a larger number
when necessary.
}
\examples{
\donttest{
#-------------------------------------------------------------------
#  Wasserstein Distance between Samples from Two Bivariate Normal
#
# * class 1 : samples from Gaussian with mean=(-1, -1)
# * class 2 : samples from Gaussian with mean=(+1, +1)
#-------------------------------------------------------------------
## SMALL EXAMPLE
set.seed(100)
m = 20
n = 10
X = matrix(rnorm(m*2, mean=-1),ncol=2) # m obs. for X
Y = matrix(rnorm(n*2, mean=+1),ncol=2) # n obs. for Y

## COMPARE WITH WASSERSTEIN 
outw = wasserstein(X, Y)
skh1 = sinkhorn(X, Y, lambda=0.05)
skh2 = sinkhorn(X, Y, lambda=0.10)

## VISUALIZE : SHOW THE PLAN AND DISTANCE
pm1 = paste0("wasserstein plan ; distance=",round(outw$distance,2))
pm2 = paste0("sinkhorn lbd=0.05; distance=",round(skh1$distance,2))
pm5 = paste0("sinkhorn lbd=0.1 ; distance=",round(skh2$distance,2))

opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
image(outw$plan, axes=FALSE, main=pm1)
image(skh1$plan, axes=FALSE, main=pm2)
image(skh2$plan, axes=FALSE, main=pm5)
par(opar)
}

}
\references{
\insertAllCited{}
}
\concept{dist_wass}
