% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_kmeans.R
\name{kmeans}
\alias{kmeans}
\title{K-Means Clustering}
\usage{
kmeans(data, k = 2, ...)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix of row-stacked observations.}

\item{k}{the number of clusters (default: 2).}

\item{...}{extra parameters including \describe{
\item{init}{initialization method; either \code{"random"} for random initialization, or \code{"plus"} for k-means++ starting.}
\item{maxiter}{the maximum number of iterations (default: 10).}
\item{nstart}{the number of random initializations (default: 5).}
}}
}
\value{
a named list of S3 class \code{T4cluster} containing 
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).} 
\item{mean}{a \eqn{(k\times p)} matrix where each row is a class mean.}
\item{wcss}{within-cluster sum of squares (WCSS).}
\item{algorithm}{name of the algorithm.}
}
}
\description{
\eqn{K}-means algorithm we provide is a wrapper to the \pkg{Armadillo}'s k-means routine.
Two types of initialization schemes are employed. Please see the parameters section for more details.
}
\examples{
# -------------------------------------------------------------
#            clustering with 'iris' dataset
# -------------------------------------------------------------
## PREPARE
data(iris)
X   = as.matrix(iris[,1:4])
lab = as.integer(as.factor(iris[,5]))

## EMBEDDING WITH PCA
X2d = Rdimtools::do.pca(X, ndim=2)$Y

## CLUSTERING WITH DIFFERENT K VALUES
cl2 = kmeans(X, k=2)$cluster
cl3 = kmeans(X, k=3)$cluster
cl4 = kmeans(X, k=4)$cluster

## VISUALIZATION
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,4), pty="s")
plot(X2d, col=lab, pch=19, main="true label")
plot(X2d, col=cl2, pch=19, main="k-means: k=2")
plot(X2d, col=cl3, pch=19, main="k-means: k=3")
plot(X2d, col=cl4, pch=19, main="k-means: k=4")
par(opar)

}
\references{
\insertRef{sanderson_armadillo_2016c}{T4cluster}
}
\concept{algorithm}
