% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correcting_splits.R
\name{correct_split_distance}
\alias{correct_split_distance}
\alias{correct_split_length}
\title{Changes lengths associated with splits to new values}
\usage{
correct_split_distance(df, new_split_length, events)

correct_split_length(df, new_split_length, events)
}
\arguments{
\item{df}{a data frame having some split columns (Split_50, Split_100 etc.)}

\item{new_split_length}{split length to rename split columns based on}

\item{events}{list of events to correct splits for}
}
\value{
a data frame where all events named in the \code{events} parameter
  have their split column labels adjusted to reflect \code{new_split_length}
}
\description{
Useful for dealing with meets where some events are split by 50 and others by
25.
}
\examples{
df <- data.frame(Name = c("Lilly King", "Caeleb Dressel"),
Event = c("Women 100 Meter Breaststroke", "Men 50 Yard Freestyle"),
Split_50 = c("29.80", "8.48"),
Split_100 = c("34.33", "9.15"))

df \%>\% correct_split_distance(
 new_split_length = 25,
 events = c("Men 50 Yard Freestyle")
)

}
