% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation-LS.R
\name{Fit.BNLS}
\alias{Fit.BNLS}
\title{Fit Bivariate Normal Regression Model via Least Squares}
\usage{
Fit.BNLS(t, s, X, sig = 0.05)
}
\arguments{
\item{t}{Target outcome vector.}

\item{s}{Surrogate outcome vector.}

\item{X}{Model matrix.}

\item{sig}{Type I error level.}
}
\value{
An object of class 'bnr' with slots containing the estimated
  regression coefficients, the target-surrogate covariance matrix, the
  information matrices for the regression and covariance parameters, and the
  residuals.
}
\description{
Estimation procedure for bivariate normal regression models in which
only the target outcome is subject to missingness.
}
\details{
The model matrix is expected in numeric format. Include an intercept if
required. Expand factors and interactions in advance.
}
\examples{
\donttest{
set.seed(100)
n <- 1e3
X <- rnorm(n)
data <- rBNR(X = X, Z = X, b = 1, a = -1, t_miss = 0.1, s_miss = 0.0)
t <- data[, 1]
s <- data[, 2]

# Model fit.
fit_bnls <- Fit.BNLS(
  t = t,
  s = s,
  X = X,
  sig = 0.05
)
}
}
