% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_analysis_BinCont_copula.R
\name{sample_copula_parameters}
\alias{sample_copula_parameters}
\title{Sample Unidentifiable Copula Parameters}
\usage{
sample_copula_parameters(
  copula_family2,
  n_sim,
  eq_cond_association = FALSE,
  lower = c(-1, -1, -1, -1),
  upper = c(1, 1, 1, 1)
)
}
\arguments{
\item{copula_family2}{Copula family of the other bivariate copulas. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family2} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{n_sim}{Number of copula parameter vectors to be sampled.}

\item{eq_cond_association}{(boolean) Indicates whether \eqn{\rho_{13;2}} and
\eqn{\rho_{24;3}} are set equal.}

\item{lower}{(numeric) Vector of length 4 that provides the lower limit,
\eqn{\boldsymbol{a} = (a_{23}, a_{13;2}, a_{24;3},
  a_{14;23})'}. Defaults to \code{c(-1, -1, -1, -1)}. If the provided lower limit
is smaller than what is allowed for a particular copula family, then the
copula family's lowest possible value is used instead.}

\item{upper}{(numeric) Vector of length 4 that provides the upper limit,
\eqn{\boldsymbol{b} = (b_{23}, b_{13;2}, b_{24;3},
  b_{14;23})'}. Defaults to \code{c(1, 1, 1, 1)}.}
}
\value{
A \code{n_sim} by \code{4} numeric matrix where each row corresponds to a
sample for \eqn{\boldsymbol{\theta}_{unid}}.
}
\description{
The \code{\link[=sample_copula_parameters]{sample_copula_parameters()}} function samples the unidentifiable copula
parameters for the partly identifiable D-vine copula model, see for example
\code{\link[=fit_copula_model_BinCont]{fit_copula_model_BinCont()}} and \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}} for more information
regarding the D-vine copula model.
}
\section{Sampling}{
In the D-vine copula model in the Information-Theoretic Causal Inference
(ITCI) framework, the following copulas are not identifiable: \eqn{c_{23}},
\eqn{c_{13;2}}, \eqn{c_{24;3}}, \eqn{c_{14;23}}. Let the corresponding
copula
parameters be \deqn{\boldsymbol{\theta}_{unid} = (\theta_{23}, \theta_{13;2},
\theta_{24;3}, \theta_{14;23})'.}
The allowable range for this parameter vector depends on the corresponding
copula families. For parsimony and comparability across different copula
families, the sampling procedure consists of two steps:
\enumerate{
\item Sample Spearman's rho parameters from a uniform distribution,
\deqn{\boldsymbol{\rho}_{unid} = (\rho_{23}, \rho_{13;2}, \rho_{24;3},
  \rho_{14;23})' \sim U(\boldsymbol{a}, \boldsymbol{b}).}
\item Transform the sampled Spearman's rho parameters to the copula parameter
scale, \eqn{\boldsymbol{\theta}_{unid}}.
}

These two steps are repeated \code{n_sim} times.
}

\section{Conditional Independence}{
In addition to range restrictions through the \code{lower} and \code{upper} arguments,
we allow for so-called conditional independence assumptions.
These assumptions entail that \eqn{\rho_{13;2} = 0} and \eqn{\rho_{24;3} =
0}. Or in other words, \eqn{U_1 \perp U_3 \, | \, U_2} and \eqn{U_2 \perp U_4 \, | \, U_3}.
In the context of a surrogate evaluation trial (where \eqn{(U_1, U_2, U_3,
U_4)'} corresponds to the probability integral transformation of \eqn{(T_0,
S_0, S_1, T_1)'}) this assumption could be justified by subject-matter knowledge.
}

