% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvCont.R
\name{plot.MetaAnalyticSurvCont}
\alias{plot.MetaAnalyticSurvCont}
\title{Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'MetaAnalyticSurvCont()' function.}
\usage{
\method{plot}{MetaAnalyticSurvCont}(x, ...)
}
\arguments{
\item{x}{An object of class 'MetaAnalyticSurvCont' fitted with the 'MetaAnalyticSurvCont()' function.}

\item{...}{...}
}
\value{
A plot of the type ggplot
}
\description{
Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'MetaAnalyticSurvCont()' function.
}
\examples{
\dontrun{
data("colorectal4")
data("prostate")
fit <- MetaAnalyticSurvCont(data = prostate, true = SURVTIME, trueind = SURVIND, surrog = PSA,
trt = TREAT, center = TRIAL, trial = TRIAL, patientid = PATID,
copula = "Hougaard", adjustment = "weighted")
plot(fit)
}

}
